<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = urldecode($_POST['id']);
$country = urldecode($_POST['country']);
$device = urldecode($_POST['device']);
$version = urldecode($_POST['version']);
$language = urldecode($_POST['language']);
$android_version = urldecode($_POST['android_version']);

// Use prepared statements to prevent SQL injection
$sql = "INSERT INTO `users` (`id`, `app_id`, `country`, `device`, `version`, `language`, `android_version`, `time`) VALUES (NULL, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind parameters and execute the statement
    $stmt->bind_param("ssssss", $id, $country, $device, $version, $language, $android_version);
    
    if ($stmt->execute()) {
        echo 'User created successfully';
    } else {
        echo 'Error creating user: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error creating user: ' . $conn->error;
}

// Close the connection
$conn->close();
?>