<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = urldecode($_POST['id']);
$title = urldecode($_POST['title']);
$type = urldecode($_POST['type']);
$artist = urldecode($_POST['artist']);
$image = urldecode($_POST['image']);
$genre = urldecode($_POST['genre']);
$album = urldecode($_POST['album']);
$path = urldecode($_POST['path']);
$itemId = urldecode($_POST['itemId']);
$appId = urldecode($_POST['appId']);
$amount = urldecode($_POST['amount']);
$currency = urldecode($_POST['currency']);
$paymentmethod = urldecode($_POST['paymentmethod']);
$duration = urldecode($_POST['duration']);
$status = urldecode($_POST['status']);
$expire = urldecode($_POST['expire']);
$time = urldecode($_POST['time']);
$start = urldecode($_POST['start']);
$accountemail = urldecode($_POST['accountemail']);
$mobile = urldecode($_POST['mobile']);
$paymentcode = urldecode($_POST['paymentcode']);
$country = urldecode($_POST['country']);

// Use prepared statements to prevent SQL injection
$sql = "INSERT INTO `payment` (`id`, `title`, `type`, `artist`, `image`, `genre`, `album`, `path`, `itemId`, `appId`, `amount`, `currency`, `paymentmethod`, `duration`, `status`, `expire`, `time`, `start`, `accountemail`, `mobile`, `paymentcode`, `country`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
 ";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind parameters and execute the statement
    $stmt->bind_param("sssssssssssssssssssss", $id, $title, $type, $artist, $image, $genre, $album, $path, $itemId, $appId, $amount, $currency, $paymentmethod, $duration, $status, $expire, $time, $start, $accountemail, $mobile, $paymentcode, $country);

    
    if ($stmt->execute()) {
        echo 'Payment made successfully';
    } else {
        echo 'Error making payment: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error making payment ' . $conn->error;
}

// Close the connection
$conn->close();
?>