<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$app_id = urldecode($_POST['appId']);

// Use prepared statements to prevent SQL injection
$sql = "DELETE FROM `notifications` WHERE `app_id` = ?";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind the app_id parameter
    $stmt->bind_param("s", $app_id);
    
    if ($stmt->execute()) {
        // Check if any rows were deleted
        if ($stmt->affected_rows > 0) {
            echo 'Notifications deleted successfully';
        } else {
            echo 'No notifications found with the provided app_id';
        }
    } else {
        echo 'Error deleting notifications: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error preparing statement: ' . $conn->error;
}

// Close the connection
$conn->close();
?>
