<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = urldecode($_POST['id']);
$new_status = "read"; // Set the status to 'read'

// Use prepared statements to prevent SQL injection
$sql = "UPDATE `notifications` SET `status` = ? WHERE `id` = ?";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind the new status and app_id parameters
    $stmt->bind_param("ss", $new_status, $id);
    
    if ($stmt->execute()) {
        // Check if any rows were updated
        if ($stmt->affected_rows > 0) {
            echo 'Notification status updated to read successfully';
        } else {
            echo 'No notifications found with the provided app_id or status already set to read';
        }
    } else {
        echo 'Error updating notification status: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error preparing statement: ' . $conn->error;
}

// Close the connection
$conn->close();
?>
