<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$notification_id = urldecode($_POST['id']); // Get notification ID from POST request

// Use prepared statements to prevent SQL injection
$sql = "DELETE FROM `notifications` WHERE `id` = ?";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind the notification ID parameter
    $stmt->bind_param("i", $notification_id);
    
    if ($stmt->execute()) {
        // Check if any rows were deleted
        if ($stmt->affected_rows > 0) {
            echo 'Notification deleted successfully';
        } else {
            echo 'No notification found with the provided ID';
        }
    } else {
        echo 'Error deleting notification: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error preparing statement: ' . $conn->error;
}

// Close the connection
$conn->close();
?>
