<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$app_id = urldecode($_POST['app_id']);
$type = urldecode($_POST['type']);
$message = urldecode($_POST['message']);
$date = urldecode($_POST['date']);
$status = urldecode($_POST['status']);
$thumb = urldecode($_POST['thumb']);
$thumb_type = urldecode($_POST['thumb_type']);

// Use prepared statements to prevent SQL injection
$sql = "INSERT INTO `notifications` (`id`, `app_id`, `type`, `message`, `date`, `status`, `thumb`, `thumb_type`) VALUES (NULL, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind parameters and execute the statement
    $stmt->bind_param("sssssss", $app_id, $type, $message, $date, $status, $thumb, $thumb_type);
    
    if ($stmt->execute()) {
        echo 'Notification created successfully';
    } else {
        echo 'Error creating Notification: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error preparing statement: ' . $conn->error;
}

// Close the connection
$conn->close();
?>
