<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = urldecode($_POST['id']);
$appId = urldecode($_POST['app_id']);

// Use prepared statements to prevent SQL injection
$sql = "INSERT INTO `likes` (`id`, `music_id`, `app_id`) VALUES (NULL,?,?)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind parameters and execute the statement
    $stmt->bind_param("ss", $id, $appId);
    
    if ($stmt->execute()) {
        echo 'Music Liked successfully';
    } else {
        echo 'Error liking music: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error liking music: ' . $conn->error;
}

// Close the connection
$conn->close();
?>