<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = urldecode($_POST['id']);
$musicId = urldecode($_POST['music_id']);
$title = urldecode($_POST['title']);
$path = urldecode($_POST['path']);
$artist = urldecode($_POST['artist']);
$album = urldecode($_POST['album']);
$image = urldecode($_POST['image']);
$genre = urldecode($_POST['genre']);

// Use prepared statements to prevent SQL injection
$sql = "INSERT INTO `recent` (`id`,`music_id`, `title`, `path`, `artist`, `album`, `image`, `genre`) VALUES (?,?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind parameters and execute the statement
    $stmt->bind_param("ssssssss", $id,$musicId, $title, $path, $artist, $album, $image, $genre);
    
    if ($stmt->execute()) {
        echo 'Recent updated successfully';
    } else {
        echo 'Error updating recent: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error preparing statement: ' . $conn->error;
}

// Close the connection
$conn->close();
?>
