<?php
include 'dataconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$id = urldecode($_POST['id']);
$listens = urldecode($_POST['listens']);

// Use prepared statements to prevent SQL injection
$sql = "INSERT INTO `listens` (`id`, `listens`) VALUES (?, ?)";

$stmt = $conn->prepare($sql);

if ($stmt) {
    // Bind parameters and execute the statement
    $stmt->bind_param("ss", $id,$listens);
    
    if ($stmt->execute()) {
        echo 'Listens updated successfully';
    } else {
        echo 'Error updating listens: ' . $stmt->error;
    }

    // Close the statement
    $stmt->close();
} else {
    echo 'Error updating listens: ' . $conn->error;
}

// Close the connection
$conn->close();
?>
